var samplePageObj = {
  // 샘플 타이틀
  title: '영역 선택 기능',
  subtitle: '시트 내에서 영역을 선택하는 방법을 알아봅니다.',
  // 샘플 설명
  desc: '마우스 드래그(기본 제공) 및 메소드(selectRow, selectRange)를 통한 영역 선택이 가능하며, 사용자가 선택 불가능한 행/열을 설정 할 수 있습니다.',

  // 객체 초기화 구문
  init: {
    Def: {
    },
    Cfg: {
      SearchMode: 0,
      Alternate: 2
    },
    LeftCols: [
      {
        Header: 'No',
        Type: 'Int',
        Width: 80,
        Align: 'Center',
        Name: 'SEQ'
      }
    ],
    Cols: [
      {
        Header: '이름',
        Name: 'sName',
        Type: 'Text',
        Width: 120,
        Align: 'Center'
      },
      {
        Header: '급여',
        Name: 'sMoney',
        Type: 'Int',
        Format: '#,### 만원',
        MaxWidth: 150,
        Align: 'Center'
      },
      {
        Header: '전화번호',
        Name: 'sPhone',
        Type: 'Text',
        Width: 150,
        CustomFormat: 'PhoneNo',
        MaxWidth: 300,
        Align: 'Center'
      },
      {
        Header: '주민/사업자 번호',
        Name: 'sId',
        Type: 'Text',
        Width: 150,
        Align: 'Center',
        EditMask: '^\\d*$',
        CustomFormat: '######-#*****|SaupNo',
        CanSelect: 0
      },
      {
        Header: '우편번호',
        Name: 'sPostNo',
        Type: 'Text',
        Width: 100,
        Align: 'Center',
        EditMask: '^\\d*$',
        Size: 6,
        CustomFormat: 'PostNo'
      },
      {
        Header: '주소',
        Name: 'sAddr',
        Type: 'Enum',
        Enum: '|서울|경기|강원|부산|인천|대구|광주|대전|강릉|울산',
        Width: 80,
        Align: 'Center'
      },
      {
        Header: '카드번호',
        Name: 'sCard',
        Type: 'Text',
        Width: 200,
        Align: 'Center',
        EditMask: '^\\d*$',
        CustomFormat: '[General] ####-####-####-####|[ Amex ] ####-######-#####',
        Size: 16
      },
      {
        Header: '코멘트',
        Name: 'sCustom',
        Type: 'Text',
        RelWidth: 1
      }
    ]
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><label>시작셀의 행 index</label><input type=\'text\' class=\'mgr10\' style=\'width: 60px;padding: 3.5px 5px 1px 5px;\' id=\'row1\' value=\'2\'><hr>'
          + '<label>시작셀의 열</label><select class=\'mgr10\' style=\'padding:2px 10px; box-sizing: border-box; vertical-align: top;\' name=\'select\' id=\'col1\'><option value=\'1\'>No</option><option value=\'2\'>이름</option><option value=\'3\' selected>급여</option><option value=\'4\'>전화번호</option><option value=\'5\'>주민/사업자 번호</option><option value=\'6\'>우편번호</option><option value=\'7\'>주소</option><option value=\'8\'>카드번호</option><option value=\'9\'>코멘트</option></select><hr>'
          + '<label>종료셀의 행 index</label><input type=\'text\' class=\'mgr10\' style=\'width: 60px;padding: 3.5px 5px 1px 5px;\' id=\'row2\' value=\'5\'><hr>'
          + '<label>종료셀의 열 <select class=\'mgr10\' style=\'padding:2px 10px; box-sizing: border-box; vertical-align: top;\' name=\'select\' id=\'col2\'><option value=\'1\'>No</option><option value=\'2\'>이름</option><option value=\'3\'>급여</option><option value=\'4\'>전화번호</option><option value=\'5\'>주민/사업자 번호</option><option value=\'6\'>우편번호</option><option value=\'7\' selected>주소</option><option value=\'8\'>카드번호</option><option value=\'9\'>코멘트</option></select><hr>'
          + '<button class=\'mgr10\' onclick=\'sampleBtn(this)\'>메소드로 영역 선택</button></div>'
          + '<div><button class=\'mgr10\' onclick=\'sampleBtn(this)\'>현재 선택영역 확인하기</button><button class=\'mgr10\' onclick=\'sampleBtn(this)\'>선택영역 취소하기</button></div>'
          + '<div><label>현재 포커스된 로우 선택 가능 여부</label><input type=\'checkbox\' name=\'FS1\' value=\'row\' checked/><hr>'
          + '<label>현재 포커스된 컬럼 선택 가능 여부</label><input type=\'checkbox\' name=\'FS2\' value=\'col\' checked/><hr>'
          + '<button class=\'mgr10\' onclick=\'sampleBtn(this)\'>변경하기</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:100%\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
  },
  // 버튼 클릭시 기능 로직
  action: function () {
    // var check = document.querySelector('input[name="CP"]:checked').value;
    switch (arguments[0].innerText) {
      case '메소드로 영역 선택':
        var row1Index = parseInt(document.getElementById('row1').value, 10);
        var row2Index = parseInt(document.getElementById('row2').value, 10);
        var col1Index = parseInt(document.getElementById('col1').value, 10);
        var col2Index = parseInt(document.getElementById('col2').value, 10);

        if (isNaN(row1Index) || isNaN(row2Index) || isNaN(col1Index) || isNaN(col2Index)) {
          alert('셀의 행/열 인덱스 번호를 확인해주세요');

          return;
        } if (row1Index > row2Index || col1Index > col2Index) {
          alert('반드시 시작 지점은 종료지점보다 좌측 상단에 위치해야 합니다');

          return;
        }
        sheet.selectRange({
          row1: sheet.getRowByIndex(row1Index),
          col1: sheet.getColByIndex(col1Index),
          row2: sheet.getRowByIndex(row2Index),
          col2: sheet.getColByIndex(col2Index)
        });
        break;
      case '현재 선택영역 확인하기':
        var range = sheet.getSelectedRanges();
        var msg = '';

        if (range.length > 0) {
          for (var i = 0; i < range.length; i++) {
            msg += range[i][0].SEQ + '행 \'' + sheet.getRowById('Header')[range[i][1]] + '\'열 부터 ' + range[i][2].SEQ + '행 \'' + sheet.getRowById('Header')[range[i][3]] + '\'열 까지를 선택하셨습니다<br>';
          }
        }
        sheet.showMessageTime({ message: msg });
        break;
      case '선택영역 취소하기':
        sheet.clearSelection();
        break;
      case '변경하기':
        var focusRow = sheet.getFocusedRow();
        var focusCol = sheet.getFocusedCol();

        if (!focusRow || !focusCol) {
          alert('포커스를 해주세요');

          return;
        }
        var row = document.querySelector('input[name="FS1"]:checked');
        var col = document.querySelector('input[name="FS2"]:checked');

        if (row) {
          focusRow.CanSelect = 1;
        } else {
          focusRow.CanSelect = 0;
        }
        if (col) {
          sheet.Cols[focusCol].CanSelect = 1;
        } else {
          sheet.Cols[focusCol].CanSelect = 0;
        }
        break;
      // no default
    }
  },

  // event구문
  event: {
    onDblClick: function (evtParam) {
      console.log('onDblClick', evtParam);
      var r = evtParam.row;

      evtParam.sheet.showEditDialog(r, 500, 400);
    }
  },

  // data
  data: [
    {
      sName: '황정열',
      sMoney: '5000',
      sPhone: '01015368874',
      sId: '801221384251',
      sAddr: '서울',
      sPostNo: '137765',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '강대호',
      sMoney: '4700',
      sPhone: '021231234',
      sId: '94873732937',
      sAddr: '경기',
      sPostNo: '142571',
      sCard: '546125847896665',
      sCustom: ''
    },
    {
      sName: '김미경',
      sMoney: '3900',
      sPhone: '04321525555',
      sId: '5494392102',
      sAddr: '강원',
      sPostNo: '570154',
      sCard: '8547955425411567',
      sCustom: ''
    },
    {
      sName: '김선희',
      sMoney: '3400',
      sPhone: '01011112222',
      sId: '3829290103',
      sAddr: '경기',
      sPostNo: '843521',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '최세희',
      sMoney: '3200',
      sPhone: '01674856874',
      sId: '405142384211',
      sAddr: '경기',
      sPostNo: '235552',
      sCard: '4587998856552145',
      sCustom: ''
    },
    {
      sName: '이명희',
      sMoney: '2900',
      sPhone: '0101538874',
      sId: '801221384251',
      sAddr: '서울',
      sPostNo: '615252',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '노효일',
      sMoney: '2300',
      sPhone: '0215368874',
      sId: '506233051223',
      sAddr: '서울',
      sPostNo: '736566',
      sCard: '8585666185411125',
      sCustom: ''
    },
    {
      sName: '원영국',
      sMoney: '2800',
      sPhone: '01075116521',
      sId: '2118204825',
      sAddr: '경기',
      sPostNo: '951137',
      sCard: '7514441556512533',
      sCustom: ''
    },
    {
      sName: '이지선',
      sMoney: '2400',
      sPhone: '025815421',
      sId: '129122361319',
      sAddr: '부산',
      sPostNo: '515426',
      sCard: '6841563125655524',
      sCustom: ''
    },
    {
      sName: '김상도',
      sMoney: '4000',
      sPhone: '0425741245',
      sId: '507142063425',
      sAddr: '경기',
      sPostNo: '751123',
      sCard: '6666555522223333',
      sCustom: ''
    },
    {
      sName: '한보라',
      sMoney: '2800',
      sPhone: '01022116587',
      sId: '2097200597',
      sAddr: '서울',
      sPostNo: '681521',
      sCard: '9999888855552222',
      sCustom: ''
    },
    {
      sName: '장태우',
      sMoney: '2800',
      sPhone: '0557256541',
      sId: '5068272842',
      sAddr: '서울',
      sPostNo: '354112',
      sCard: '3333444455556666',
      sCustom: ''
    },
    {
      sName: '정필석',
      sMoney: '4000',
      sPhone: '0262642080',
      sId: '1298363035',
      sAddr: '경기',
      sPostNo: '846311',
      sCard: '4444222211113255',
      sCustom: ''
    },
    {
      sName: '조성목',
      sMoney: '4100',
      sPhone: '0261254045',
      sId: '4102263574',
      sAddr: '경기',
      sPostNo: '5153655',
      sCard: '5641122315415133',
      sCustom: ''
    },
    {
      sName: '유봉근',
      sMoney: '4200',
      sPhone: '022222222',
      sId: '4856482165',
      sAddr: '서울',
      sPostNo: '412132',
      sCard: '8584154122235565',
      sCustom: ''
    },
    {
      sName: '오필환',
      sMoney: '3700',
      sPhone: '01098415521',
      sId: '2118208651',
      sAddr: '서울',
      sPostNo: '355111',
      sCard: '3554455516545665',
      sCustom: ''
    },
    {
      sName: '송복석',
      sMoney: '3900',
      sPhone: '0435746521',
      sId: '5485783829',
      sAddr: '경기',
      sPostNo: '512321',
      sCard: '5546555111415351',
      sCustom: ''
    },
    {
      sName: '김남연',
      sMoney: '3600',
      sPhone: '0545615477',
      sId: '206232384536',
      sAddr: '대구',
      sPostNo: '154234',
      sCard: '5655154415412335',
      sCustom: ''
    },
    {
      sName: '한혜선',
      sMoney: '2900',
      sPhone: '025555501',
      sId: '2516521565',
      sAddr: '서울',
      sPostNo: '541657',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '조미미',
      sMoney: '2500',
      sPhone: '01065840714',
      sId: '56452435324',
      sAddr: '울산',
      sPostNo: '741351',
      sCard: '5461258478966655',
      sCustom: ''
    },
    {
      sName: '고은혜',
      sMoney: '2600',
      sPhone: '0423522541',
      sId: '1298041207',
      sAddr: '서울',
      sPostNo: '256165',
      sCard: '8547955425411567',
      sCustom: ''
    },
    {
      sName: '성미열',
      sMoney: '2700',
      sPhone: '0335841152',
      sId: '801225384251',
      sAddr: '서울',
      sPostNo: '984561',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '김영중',
      sMoney: '2800',
      sPhone: '0325889885',
      sId: '80789852148',
      sAddr: '인천',
      sPostNo: '137765',
      sCard: '4587998856552145',
      sCustom: ''
    },
    {
      sName: '김기호',
      sMoney: '3800',
      sPhone: '01075116521',
      sId: '138206820',
      sAddr: '서울',
      sPostNo: '561465',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '하태선',
      sMoney: '2800',
      sPhone: '025815421',
      sId: '6098204963',
      sAddr: '서울',
      sPostNo: '846315',
      sCard: '8585666185411125',
      sCustom: ''
    },
    {
      sName: '김정민',
      sMoney: '3200',
      sPhone: '0425741245',
      sId: '405142384211',
      sAddr: '경기',
      sPostNo: '446123',
      sCard: '7514441556512533',
      sCustom: ''
    },
    {
      sName: '장성우',
      sMoney: '3700',
      sPhone: '01022116587',
      sId: '53231234348',
      sAddr: '서울',
      sPostNo: '846311',
      sCard: '6841563125655524',
      sCustom: ''
    },
    {
      sName: '강윤식',
      sMoney: '3500',
      sPhone: '0557256541',
      sId: '506243051223',
      sAddr: '서울',
      sPostNo: '515365',
      sCard: '6666555522223333',
      sCustom: ''
    },
    {
      sName: '김수연',
      sMoney: '3000',
      sPhone: '0262642080',
      sId: '2118204825',
      sAddr: '경기',
      sPostNo: '412132',
      sCard: '9999888855552222',
      sCustom: ''
    },
    {
      sName: '정은지',
      sMoney: '3000',
      sPhone: '0261254045',
      sId: '1232432121',
      sAddr: '광주',
      sPostNo: '355111',
      sCard: '3333444455556666',
      sCustom: ''
    },
    {
      sName: '정창호',
      sMoney: '2700',
      sPhone: '022222222',
      sId: '507142048425',
      sAddr: '서울',
      sPostNo: '512321',
      sCard: '4444222211113255',
      sCustom: ''
    },
    {
      sName: '김대현',
      sMoney: '3300',
      sPhone: '01098415521',
      sId: '2098200597',
      sAddr: '서울',
      sPostNo: '154234',
      sCard: '5641122315415133',
      sCustom: ''
    },
    {
      sName: '안남주',
      sMoney: '3800',
      sPhone: '0435746521',
      sId: '5068272842',
      sAddr: '서울',
      sPostNo: '5416570',
      sCard: '8584154122235565',
      sCustom: ''
    },
    {
      sName: '이민수',
      sMoney: '3800',
      sPhone: '0545615477',
      sId: '1298563035',
      sAddr: '경기',
      sPostNo: '741351',
      sCard: '3554455516545665',
      sCustom: ''
    },
    {
      sName: '최갑석',
      sMoney: '3800',
      sPhone: '025555501',
      sId: '41010223574',
      sAddr: '경기',
      sPostNo: '256165',
      sCard: '5546555111415351',
      sCustom: ''
    },
    {
      sName: '김태헌',
      sMoney: '3700',
      sPhone: '01065840714',
      sId: '4098272390',
      sAddr: '대전',
      sPostNo: '984561',
      sCard: '5655154415412335',
      sCustom: ''
    },
    {
      sName: '박정석',
      sMoney: '3200',
      sPhone: '0423522541',
      sId: '3498589498',
      sAddr: '서울',
      sPostNo: '137765',
      sCard: '9999888855552222',
      sCustom: ''
    },
    {
      sName: '권기윤',
      sMoney: '3700',
      sPhone: '0335841152',
      sId: '231254659987',
      sAddr: '경기',
      sPostNo: '561465',
      sCard: '3333444455556666',
      sCustom: ''
    },
    {
      sName: '김승운',
      sMoney: '3900',
      sPhone: '0325889885',
      sId: '122325565485',
      sAddr: '경기',
      sPostNo: '846315',
      sCard: '4444222211113255',
      sCustom: ''
    },
    {
      sName: '이해영',
      sMoney: '2300',
      sPhone: '01015368874',
      sId: '45331243212',
      sAddr: '경기',
      sPostNo: '446123',
      sCard: '5641122315415133',
      sCustom: ''
    },
    {
      sName: '김다은',
      sMoney: '3500',
      sPhone: '0123368874',
      sId: '80234384251',
      sAddr: '강릉',
      sPostNo: '137765',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '이준서',
      sMoney: '4500',
      sPhone: '01075464123',
      sId: '124151852148',
      sAddr: '경기',
      sPostNo: '142571',
      sCard: '546125847896665',
      sCustom: ''
    },
    {
      sName: '한주원',
      sMoney: '3200',
      sPhone: '01046575232',
      sId: '1820644820',
      sAddr: '강원',
      sPostNo: '570154',
      sCard: '8547955425411567',
      sCustom: ''
    },
    {
      sName: '도민준',
      sMoney: '3900',
      sPhone: '01011112222',
      sId: '690902043',
      sAddr: '경기',
      sPostNo: '843521',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '김지우',
      sMoney: '4200',
      sPhone: '01074856874',
      sId: '4023825444211',
      sAddr: '경기',
      sPostNo: '235552',
      sCard: '4587998856552145',
      sCustom: ''
    },
    {
      sName: '이하윤',
      sMoney: '5900',
      sPhone: '01035438874',
      sId: '80234865251',
      sAddr: '서울',
      sPostNo: '615252',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '김서현',
      sMoney: '2350',
      sPhone: '01021532874',
      sId: '6243291223',
      sAddr: '대구',
      sPostNo: '736566',
      sCard: '8585666185411125',
      sCustom: ''
    },
    {
      sName: '천예준',
      sMoney: '2300',
      sPhone: '01075126521',
      sId: '29548214825',
      sAddr: '경기',
      sPostNo: '951137',
      sCard: '7514441556512533',
      sCustom: ''
    },
    {
      sName: '양지호',
      sMoney: '2700',
      sPhone: '01025815421',
      sId: '1292456319',
      sAddr: '광주',
      sPostNo: '515426',
      sCard: '6841563125655524',
      sCustom: ''
    },
    {
      sName: '김지수',
      sMoney: '3500',
      sPhone: '01042741245',
      sId: '5148063425',
      sAddr: '경기',
      sPostNo: '751123',
      sCard: '6666555522223333',
      sCustom: ''
    },
    {
      sName: '박하은',
      sMoney: '3800',
      sPhone: '01023116587',
      sId: '2098974597',
      sAddr: '서울',
      sPostNo: '681521',
      sCard: '9999888855552222',
      sCustom: ''
    },
    {
      sName: '이태연',
      sMoney: '2900',
      sPhone: '01055725541',
      sId: '546872842',
      sAddr: '서울',
      sPostNo: '354112',
      sCard: '3333444455556666',
      sCustom: ''
    },
    {
      sName: '김민수',
      sMoney: '4000',
      sPhone: '01022642080',
      sId: '1705363035',
      sAddr: '경기',
      sPostNo: '846311',
      sCard: '4444222211113255',
      sCustom: ''
    },
    {
      sName: '한재원',
      sMoney: '4200',
      sPhone: '01026254045',
      sId: '4255693574',
      sAddr: '부산',
      sPostNo: '5153655',
      sCard: '5641122315415133',
      sCustom: ''
    },
    {
      sName: '김영한',
      sMoney: '3900',
      sPhone: '01022222222',
      sId: '4091234690',
      sAddr: '서울',
      sPostNo: '412132',
      sCard: '8584154122235565',
      sCustom: ''
    },
    {
      sName: '이민경',
      sMoney: '2500',
      sPhone: '01098315521',
      sId: '21450808651',
      sAddr: '서울',
      sPostNo: '355111',
      sCard: '3554455516545665',
      sCustom: ''
    },
    {
      sName: '이혜수',
      sMoney: '3400',
      sPhone: '01042574621',
      sId: '73463678921',
      sAddr: '경기',
      sPostNo: '512321',
      sCard: '5546555111415351',
      sCustom: ''
    },
    {
      sName: '이현석',
      sMoney: '3100',
      sPhone: '01054615477',
      sId: '203812354536',
      sAddr: '서울',
      sPostNo: '154234',
      sCard: '5655154415412335',
      sCustom: ''
    },
    {
      sName: '송형진',
      sMoney: '3600',
      sPhone: '0315255501',
      sId: '1231544565',
      sAddr: '서울',
      sPostNo: '541657',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '송지은',
      sMoney: '2100',
      sPhone: '01062840714',
      sId: '1108264699',
      sAddr: '대전',
      sPostNo: '741351',
      sCard: '5461258478966655',
      sCustom: ''
    },
    {
      sName: '이현지',
      sMoney: '2300',
      sPhone: '023522541',
      sId: '1298261207',
      sAddr: '서울',
      sPostNo: '256165',
      sCard: '8547955425411567',
      sCustom: ''
    },
    {
      sName: '성지현',
      sMoney: '2700',
      sPhone: '01032841152',
      sId: '54645645623',
      sAddr: '서울',
      sPostNo: '984561',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '임재연',
      sMoney: '2500',
      sPhone: '01025839885',
      sId: '807151852148',
      sAddr: '인천',
      sPostNo: '137765',
      sCard: '4587998856552145',
      sCustom: ''
    },
    {
      sName: '서지원',
      sMoney: '4800',
      sPhone: '01073126521',
      sId: '138206820',
      sAddr: '서울',
      sPostNo: '561465',
      sCard: '1234123412341234',
      sCustom: ''
    },
    {
      sName: '신호진',
      sMoney: '3500',
      sPhone: '025825421',
      sId: '6098204963',
      sAddr: '서울',
      sPostNo: '846315',
      sCard: '8585666185411125',
      sCustom: ''
    },
    {
      sName: '김정만',
      sMoney: '3200',
      sPhone: '0325741245',
      sId: '405142384211',
      sAddr: '경기',
      sPostNo: '446123',
      sCard: '7514441556512533',
      sCustom: ''
    },
    {
      sName: '김성우',
      sMoney: '3700',
      sPhone: '01022112587',
      sId: '801221384251',
      sAddr: '서울',
      sPostNo: '846311',
      sCard: '6841563125655524',
      sCustom: ''
    },
    {
      sName: '강준식',
      sMoney: '3300',
      sPhone: '01017256541',
      sId: '506243051223',
      sAddr: '서울',
      sPostNo: '515365',
      sCard: '6666555522223333',
      sCustom: ''
    },
    {
      sName: '오지현',
      sMoney: '3100',
      sPhone: '0312642080',
      sId: '2116204825',
      sAddr: '경기',
      sPostNo: '412132',
      sCard: '9999888855552222',
      sCustom: ''
    },
    {
      sName: '정민지',
      sMoney: '3900',
      sPhone: '026254045',
      sId: '1298261319',
      sAddr: '서울',
      sPostNo: '355111',
      sCard: '3333444455556666',
      sCustom: ''
    },
    {
      sName: '김천호',
      sMoney: '2700',
      sPhone: '022122222',
      sId: '507142063425',
      sAddr: '서울',
      sPostNo: '512321',
      sCard: '4444222211113255',
      sCustom: ''
    },
    {
      sName: '신대현',
      sMoney: '3700',
      sPhone: '01093415521',
      sId: '2098200597',
      sAddr: '서울',
      sPostNo: '154234',
      sCard: '5641122315415133',
      sCustom: ''
    },
    {
      sName: '안기호',
      sMoney: '3300',
      sPhone: '0435246521',
      sId: '5078272842',
      sAddr: '울산',
      sPostNo: '5416570',
      sCard: '8584154122235565',
      sCustom: ''
    },
    {
      sName: '이진수',
      sMoney: '3800',
      sPhone: '01025615477',
      sId: '1298263035',
      sAddr: '울산',
      sPostNo: '741351',
      sCard: '3554455516545665',
      sCustom: ''
    },
    {
      sName: '최현석',
      sMoney: '3800',
      sPhone: '0315552501',
      sId: '410102263574',
      sAddr: '경기',
      sPostNo: '256165',
      sCard: '5546555111415351',
      sCustom: ''
    },
    {
      sName: '김태수',
      sMoney: '3700',
      sPhone: '01065840714',
      sId: '4098272390',
      sAddr: '경기',
      sPostNo: '984561',
      sCard: '5655154415412335',
      sCustom: ''
    },
    {
      sName: '김주연',
      sMoney: '4500',
      sPhone: '023522541',
      sId: '2118558851',
      sAddr: '서울',
      sPostNo: '137765',
      sCard: '9999888855552222',
      sCustom: ''
    },
    {
      sName: '이기원',
      sMoney: '3700',
      sPhone: '01058412152',
      sId: '703301678921',
      sAddr: '대전',
      sPostNo: '561465',
      sCard: '3333444455556666',
      sCustom: ''
    },
    {
      sName: '김성현',
      sMoney: '2900',
      sPhone: '0315889885',
      sId: '854875798234',
      sAddr: '경기',
      sPostNo: '846315',
      sCard: '4444222211113255',
      sCustom: ''
    },
    {
      sName: '이해준',
      sMoney: '2300',
      sPhone: '01015368874',
      sId: '1861312319',
      sAddr: '경기',
      sPostNo: '446123',
      sCard: '5641122315415133',
      sCustom: ''
    }
  ]

};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
